<?php
require_once 'config.php';
$settings = getSettings();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_title']; ?></title>
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <style>
        :root {
            --primary-color: <?php echo $settings['theme_color']; ?>;
            --light-color: #ffffff;
            --text-color: #374151;
            --border-color: #e5e7eb;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--light-color);
            color: var(--text-color);
        }
        
        .hero-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .card-hover {
            transition: all 0.3s ease;
        }
        
        .card-hover:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
        
        .blur-overlay {
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
        }
        
        .feature-icon {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto;
            font-size: 30px;
        }
        
        /* Custom animations */
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        
        .float-animation {
            animation: float 3s ease-in-out infinite;
        }
        
        /* Progress bar animation */
        .progress-bar {
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color) 0%, #8b5cf6 100%);
            width: 0;
            transition: width 2s ease;
        }
        
        .progress-bar.active {
            width: 100%;
        }
    </style>
</head>
<body class="min-h-screen bg-gray-50">
    <!-- Navigation -->
    <nav class="bg-white shadow-lg sticky top-0 z-50">
        <div class="container mx-auto px-6 py-4">
            <div class="flex justify-between items-center">
                <a href="/" class="text-2xl font-bold text-gray-800 hover:text-blue-600 transition duration-300">
                    <i class="fas fa-rocket mr-2"></i>ProjectSale
                </a>
                
                <div class="flex items-center space-x-6">
                    <?php if(isLoggedIn()): ?>
                        <?php if(isActiveUser()): ?>
                            <a href="dashboard.php" class="text-gray-700 hover:text-blue-600 font-medium">
                                <i class="fas fa-tachometer-alt mr-1"></i> Dashboard
                            </a>
                            <a href="products.php" class="text-gray-700 hover:text-blue-600 font-medium">
                                <i class="fas fa-shopping-bag mr-1"></i> Products
                            </a>
                        <?php else: ?>
                            <div class="relative group">
                                <span class="text-gray-700 font-medium cursor-default">
                                    <i class="fas fa-lock mr-1"></i> Account Inactive
                                </span>
                                <div class="absolute hidden group-hover:block bg-white p-3 rounded-lg shadow-lg z-10 w-64">
                                    <p class="text-sm text-gray-600">Activate your account to access all features</p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <a href="profile.php" class="text-gray-700 hover:text-blue-600 font-medium">
                            <i class="fas fa-user mr-1"></i> Profile
                        </a>
                        <a href="logout.php" class="bg-red-500 text-white px-4 py-2 rounded-lg hover:bg-red-600 transition duration-300">
                            <i class="fas fa-sign-out-alt mr-1"></i> Logout
                        </a>
                    <?php else: ?>
                        <a href="login.php" class="text-gray-700 hover:text-blue-600 font-medium">
                            <i class="fas fa-sign-in-alt mr-1"></i> Login
                        </a>
                        <a href="register.php" class="bg-blue-500 text-white px-6 py-2 rounded-lg hover:bg-blue-600 transition duration-300 font-medium shadow-md hover:shadow-lg">
                            <i class="fas fa-user-plus mr-1"></i> Register
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-gradient text-white py-20">
        <div class="container mx-auto px-6 text-center">
            <h1 class="text-5xl font-bold mb-6 animate__animated animate__fadeInDown">
                Welcome to Digital Project Marketplace
            </h1>
            <p class="text-xl mb-8 max-w-2xl mx-auto animate__animated animate__fadeInUp animate__delay-1s">
                Buy and sell premium digital products, scripts, and projects with secure transactions
            </p>
            
            <?php if(!isLoggedIn()): ?>
                <div class="animate__animated animate__fadeInUp animate__delay-2s">
                    <a href="register.php" class="bg-white text-blue-600 px-8 py-3 rounded-full text-lg font-semibold hover:shadow-2xl transition duration-300 transform hover:scale-105 inline-block">
                        <i class="fas fa-play-circle mr-2"></i> Get Started Now
                    </a>
                </div>
            <?php elseif(!isActiveUser()): ?>
                <div class="bg-white/10 blur-overlay rounded-2xl p-8 max-w-2xl mx-auto mt-10 animate__animated animate__pulse animate__infinite">
                    <h3 class="text-2xl font-bold mb-4">🔒 Account Not Active</h3>
                    <p class="mb-6">Activate your account to unlock all features and access premium products</p>
                    <div class="mb-6">
                        <div class="flex justify-between text-sm mb-2">
                            <span>Activation Progress</span>
                            <span>0%</span>
                        </div>
                        <div class="bg-gray-700 rounded-full h-2">
                            <div class="progress-bar rounded-full"></div>
                        </div>
                    </div>
                    <a href="activate.php" class="bg-yellow-400 text-gray-900 px-8 py-3 rounded-full font-bold hover:bg-yellow-500 transition duration-300 inline-block">
                        <i class="fas fa-bolt mr-2"></i> Activate Account (৳<?php echo $settings['activation_fee']; ?>)
                    </a>
                </div>
            <?php else: ?>
                <div class="bg-white/10 blur-overlay rounded-2xl p-8 max-w-2xl mx-auto mt-10 animate__animated animate__fadeInUp">
                    <h3 class="text-2xl font-bold mb-4">🎉 Welcome Back!</h3>
                    <p class="mb-6">Your account is active. Start exploring our premium collection</p>
                    <a href="products.php" class="bg-green-400 text-gray-900 px-8 py-3 rounded-full font-bold hover:bg-green-500 transition duration-300 inline-block">
                        <i class="fas fa-shopping-cart mr-2"></i> Browse Products
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-20 bg-white">
        <div class="container mx-auto px-6">
            <h2 class="text-4xl font-bold text-center mb-16 text-gray-800">Why Choose Our Platform?</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-12">
                <!-- Feature 1 -->
                <div class="text-center card-hover p-8 rounded-2xl bg-gradient-to-br from-blue-50 to-indigo-50">
                    <div class="feature-icon bg-blue-100 text-blue-600 mb-6 float-animation">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-800">Secure Transactions</h3>
                    <p class="text-gray-600">Safe and encrypted payment system with instant balance updates</p>
                </div>
                
                <!-- Feature 2 -->
                <div class="text-center card-hover p-8 rounded-2xl bg-gradient-to-br from-green-50 to-teal-50">
                    <div class="feature-icon bg-green-100 text-green-600 mb-6 float-animation" style="animation-delay: 0.5s">
                        <i class="fas fa-users"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-800">Referral System</h3>
                    <p class="text-gray-600">Earn up to <?php echo $settings['referral_percentage']; ?>% commission on referrals</p>
                </div>
                
                <!-- Feature 3 -->
                <div class="text-center card-hover p-8 rounded-2xl bg-gradient-to-br from-purple-50 to-pink-50">
                    <div class="feature-icon bg-purple-100 text-purple-600 mb-6 float-animation" style="animation-delay: 1s">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <h3 class="text-2xl font-bold mb-4 text-gray-800">Instant Delivery</h3>
                    <p class="text-gray-600">Get digital products instantly after purchase confirmation</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Categories Preview -->
    <section class="py-20 bg-gray-50">
        <div class="container mx-auto px-6">
            <h2 class="text-4xl font-bold text-center mb-16 text-gray-800">Product Categories</h2>
            
            <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                <?php
                $categories_query = "SELECT * FROM categories WHERE id IN (SELECT DISTINCT category_id FROM products) ORDER BY display_order LIMIT 8";
                $categories_result = $conn->query($categories_query);
                
                if($categories_result->num_rows > 0) {
                    while($category = $categories_result->fetch_assoc()) {
                ?>
                <div class="bg-white rounded-xl p-6 text-center shadow-md hover:shadow-xl transition duration-300 card-hover">
                    <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-folder text-blue-600 text-2xl"></i>
                    </div>
                    <h3 class="font-semibold text-lg text-gray-800"><?php echo $category['name']; ?></h3>
                    <p class="text-gray-500 text-sm mt-2">Premium Projects</p>
                </div>
                <?php
                    }
                } else {
                    echo '<p class="text-center col-span-4 text-gray-500">Categories will appear here</p>';
                }
                ?>
            </div>
        </div>
    </section>

    <!-- Call to Action -->
    <section class="py-20 bg-gradient-to-r from-blue-600 to-indigo-700 text-white">
        <div class="container mx-auto px-6 text-center">
            <h2 class="text-4xl font-bold mb-8">Ready to Start Earning?</h2>
            <p class="text-xl mb-10 max-w-2xl mx-auto">Join thousands of members who are already making money through our platform</p>
            
            <div class="flex flex-col md:flex-row justify-center gap-6">
                <a href="register.php" class="bg-white text-blue-600 px-10 py-4 rounded-full text-lg font-bold hover:shadow-2xl transition duration-300 transform hover:scale-105">
                    <i class="fas fa-user-plus mr-2"></i> Join Now Free
                </a>
                <a href="telegram.com" target="_blank" class="bg-transparent border-2 border-white text-white px-10 py-4 rounded-full text-lg font-bold hover:bg-white/10 transition duration-300">
                    <i class="fab fa-telegram mr-2"></i> Join Telegram Group
                </a>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-800 text-white py-12">
        <div class="container mx-auto px-6">
            <div class="flex flex-col md:flex-row justify-between items-center">
                <div class="mb-6 md:mb-0">
                    <h3 class="text-2xl font-bold mb-4">ProjectSale</h3>
                    <p class="text-gray-400">Premium digital marketplace since 2024</p>
                </div>
                
                <div class="flex space-x-6">
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <i class="fab fa-facebook text-2xl"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <i class="fab fa-telegram text-2xl"></i>
                    </a>
                    <a href="#" class="text-gray-400 hover:text-white transition duration-300">
                        <i class="fab fa-whatsapp text-2xl"></i>
                    </a>
                </div>
            </div>
            
            <div class="border-t border-gray-700 mt-8 pt-8 text-center text-gray-400">
                <p>&copy; <?php echo date('Y'); ?> ProjectSale. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script>
        // Progress bar animation on page load
        document.addEventListener('DOMContentLoaded', function() {
            const progressBar = document.querySelector('.progress-bar');
            if(progressBar) {
                setTimeout(() => {
                    progressBar.classList.add('active');
                }, 500);
            }
            
            // Floating animation for elements
            const floatElements = document.querySelectorAll('.float-animation');
            floatElements.forEach((el, index) => {
                el.style.animationDelay = `${index * 0.3}s`;
            });
            
            // Smooth hover effects
            const cards = document.querySelectorAll('.card-hover');
            cards.forEach(card => {
                card.addEventListener('mouseenter', () => {
                    card.style.transform = 'translateY(-10px)';
                });
                card.addEventListener('mouseleave', () => {
                    card.style.transform = 'translateY(0)';
                });
            });
        });
    </script>
</body>
</html>